---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-ci.yml - test job.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/ci.yml` - CIワークフロー定義
- E-02: `package.json` - npm scripts定義
- E-03: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークフロー名はCI | E-01 (line 1) | ○ |
| C-02 | pull_requestでトリガー | E-01 (line 3) | ○ |
| C-03 | paths-ignoreでbuild/**, docs/**, files/**を除外 | E-01 (lines 5-8) | ○ |
| C-04 | permissions: contents: read | E-01 (lines 10-11) | ○ |
| C-05 | ジョブ名は"Lint, Unit, Unit addons, Circular dependencies & Examples testing" | E-01 (line 15) | ○ |
| C-06 | ubuntu-latestで実行 | E-01 (line 16) | ○ |
| C-07 | actions/checkout@v6を使用（コミットハッシュ指定） | E-01 (line 19) | ○ |
| C-08 | actions/setup-node@v6を使用（コミットハッシュ指定） | E-01 (line 21) | ○ |
| C-09 | Node.js 24を使用 | E-01 (line 23) | ○ |
| C-10 | npmキャッシュを有効化 | E-01 (line 24) | ○ |
| C-11 | npm ciで依存関係インストール | E-01 (line 26) | ○ |
| C-12 | npm run lintでLintテスト | E-01 (lines 28-29) | ○ |
| C-13 | npm run test-unitで単体テスト | E-01 (lines 31-32) | ○ |
| C-14 | npm run test-unit-addonsでアドオンテスト | E-01 (lines 34-35) | ○ |
| C-15 | npm run test-e2e-covでカバレッジチェック | E-01 (lines 37-38) | ○ |
| C-16 | lintはeslint srcを実行 | E-02 (line 61) | ○ |
| C-17 | test-unitはqunit test/unit/three.source.unit.jsを実行 | E-02 (line 63) | ○ |
| C-18 | test-unit-addonsはqunit test/unit/three.addons.unit.jsを実行 | E-02 (line 64) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー定義ファイルから完全に処理内容を把握可能
- 0: 低リスク - 各ステップのコマンドはpackage.jsonと整合

## 6) レビュアーチェックリスト（最小）
- [ ] Node.jsバージョンが最新LTSと整合しているか確認
- [ ] actionsのバージョン（コミットハッシュ）が最新のセキュアなものか確認
